/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer;

import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.ConfigData;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.annotation.Config;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.serializer.ConfigSerializer;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.shadowed.blue.endless.jankson.Jankson;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.shadowed.blue.endless.jankson.impl.SyntaxError;
import com.therandomlabs.randompatches.shadowed.me.shedaniel.autoconfig1u.util.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.fml.loading.FMLPaths;

public class JanksonConfigSerializer<T extends ConfigData>
implements ConfigSerializer<T> {
    private Config definition;
    private Class<T> configClass;
    private Jankson jankson;

    public JanksonConfigSerializer(Config definition, Class<T> configClass, Jankson jankson) {
        this.definition = definition;
        this.configClass = configClass;
        this.jankson = jankson;
    }

    public JanksonConfigSerializer(Config definition, Class<T> configClass) {
        this(definition, configClass, Jankson.builder().build());
    }

    private Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().toAbsolutePath().resolve(this.definition.name() + ".json5");
    }

    @Override
    public void serialize(T config) throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            writer.write(this.jankson.toJson(config).toJson(true, true));
            writer.close();
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException(e);
        }
    }

    @Override
    public T deserialize() throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                return (T)((ConfigData)this.jankson.fromJson(this.jankson.load(this.getConfigPath().toFile()), this.configClass));
            }
            catch (SyntaxError | IOException e) {
                throw new ConfigSerializer.SerializationException(e);
            }
        }
        return this.createDefault();
    }

    @Override
    public T createDefault() {
        return (T)((ConfigData)Utils.constructUnsafely(this.configClass));
    }
}

